import 'dart:convert';

import 'package:get/get.dart';
import 'package:viser_remit/core/helper/string_format_helper.dart';
import 'package:viser_remit/data/repo/send_money_history/send_money_history_repo.dart';

import '../../../view/components/snack_bar/show_custom_snackbar.dart';
import '../../model/global/response_model/response_model.dart';
import '../../model/send_money_history/send_money_history_response_model.dart';

class SendMoneyHistoryController extends GetxController {
  SendMoneyHistoryRepo sendMoneyHistoryRepo;
  SendMoneyHistoryController({required this.sendMoneyHistoryRepo});

  String status = '1';

  bool isLoading = true;

  List<Data> sendMoneyHistoryList = [];

  Future<void> loadSendMoneyHistoryData() async {
    isLoading = true;
    update();

    ResponseModel model = await sendMoneyHistoryRepo.getSendMoneyHistoryData();

    if (model.statusCode == 200) {
      sendMoneyHistoryList.clear();

      SendMoneyHistoryResponseModel sendMoneyHistoryResponseModel = SendMoneyHistoryResponseModel.fromJson(jsonDecode(model.responseJson));

      if (sendMoneyHistoryResponseModel.mainModel?.transfers?.data != null && sendMoneyHistoryResponseModel.mainModel!.transfers!.data!.isNotEmpty) {
        sendMoneyHistoryList.addAll(sendMoneyHistoryResponseModel.mainModel!.transfers!.data!);
      }
    } else {
      CustomSnackBar.error(errorList: [model.message]);
    }

    isLoading = false;
    update();
  }

  int currentIndex = -1;

  void setCurrentIndex(int index) {
    currentIndex = index;
    update();
  }

  void getCurrentHistoryInfo() {}

  String getConversionRate() {
    String conversionRate = "1 ${sendMoneyHistoryList[currentIndex].sendingCurrency} = "
        "${Converter.formatNumber(sendMoneyHistoryList[currentIndex].conversionRate.toString())} "
        "${sendMoneyHistoryList[currentIndex].recipientCurrency}";
    return conversionRate;
  }

  String getSentAmountIncludingCharge() {
    String charge = "${Converter.formatNumber((double.parse(sendMoneyHistoryList[currentIndex].sendingAmount.toString()) + double.parse(sendMoneyHistoryList[currentIndex].sendingCharge.toString())).toString())} "
        "${sendMoneyHistoryList[currentIndex].sendingCurrency}";
    return charge;
  }

  String getAmountIncludingCharge() {
    String charge = Converter.formatNumber((double.parse(sendMoneyHistoryList[currentIndex].sendingAmount.toString()) + double.parse(sendMoneyHistoryList[currentIndex].sendingCharge.toString())).toString());
    return charge;
  }

  String getConversionRateInBaseCurrency() {
    String rate = "1 ${sendMoneyHistoryRepo.apiClient.getCurrencyOrUsername(isCurrency: true)} = "
        "${Converter.formatNumber(sendMoneyHistoryList[currentIndex].baseCurrencyRate.toString())} "
        "${sendMoneyHistoryList[currentIndex].sendingCurrency}";

    return rate;
  }

  String getSendingAmountIncludingCharge() {
    String amount = "${Converter.formatNumber((double.parse(sendMoneyHistoryList[currentIndex].baseCurrencyAmount.toString()) + double.parse(sendMoneyHistoryList[currentIndex].baseCurrencyCharge.toString())).toString())} "
        "${sendMoneyHistoryRepo.apiClient.getCurrencyOrUsername(isCurrency: true)}";
    return amount;
  }

  String getSendingAmountIncludingChargeAndGetwayChanrage() {
    double money = (double.parse(sendMoneyHistoryList[currentIndex].baseCurrencyAmount.toString()) + double.parse(sendMoneyHistoryList[currentIndex].baseCurrencyCharge.toString()));
    if (sendMoneyHistoryList[currentIndex].deposit != null) {
      money += double.parse(sendMoneyHistoryList[currentIndex].deposit!.charge.toString());
    }
    String amount = "${Converter.formatNumber(money.toString()).toString()} "
        "${sendMoneyHistoryRepo.apiClient.getCurrencyOrUsername(isCurrency: true)}";
    return amount;
  }
}
